/**
 * example shows how to parse a raw JSON string to a javascript object.
 * no idea what JSON is? then have a read here: http://en.wikipedia.org/wiki/JSON
 */

#includepath "~/Documents/;%USERPROFILE%Documents";
#include "basiljs/bundle/basil.js";

// to load an external json file use 
var jsonString = b.loadString("data.json")
var amount;
var jsonData;

function setup() {
    // parse JSON
    jsonData = b.JSON.decode(jsonString);
    amount = jsonData.percentages.length;

    b.textAlign(Justification.LEFT_ALIGN, VerticalJustification.CENTER_ALIGN);
    b.noStroke();
    b.fill(b.color(0, 0, 255));
};

function draw() {
    createGraph();
	b.addPage();
	b.page(2);
	createGraph();
}

function createGraph(){
	for (var i = 0; i < amount; i++) {
		//b.characterStyle('text');
        b.text(jsonData.percentages[i].percentage + '%', 10, i * (b.height / amount), 60, (b.height / amount));
        b.fill(b.color(110, 130, 255));
        b.rect(70, i * (b.height / amount), b.width - 70, (b.height / amount));
        b.fill(b.color(0, 0, 255));
        b.rect(70, i * (b.height / amount), ((b.width - 70) / 100) * jsonData.percentages[i].percentage, (b.height / amount));
    };
}

b.go();