#includepath "~/Documents/;%USERPROFILE%Documents";
#include "basiljs/bundle/basil.js";

//my travelpoints
var history = {
	"points": [
		{
			"place": "Home",
			"lat": 52.3608419,
			"lng": 4.9303907
		},
		{
			"place": "Station Almere",
			"lat": 52.369083,
			"lng": 5.1910917
		},
		{
			"place": "Station Zwolle",
			"lat": 52.5055809,
			"lng": 6.0884094
		},
		{
			"place": "Station Assen",
			"lat": 52.9915302,
			"lng": 6.5679057
		},
		{
			"place": "Station Groningen",
			"lat": 53.2112924,
			"lng": 6.5635985
		},
		{
			"place": "Academie Minerva",
			"lat": 53.2148122,
			"lng": 6.5594097
		}
	]
}

//which area to show, left top coordinates to right bottom coordinates (netherlands)
var boundingArea = {
	"leftTop": {
		"lat": 53.675638,
		"lng": 3.192466
	},
	"rightBottom": {
		"lat": 50.548829,
		"lng": 7.262245
	}
}

function setup() {
	b.fill(0);

	//create background
	b.rect(0,0, b.width, b.height);

	b.stroke(255);
	b.strokeWeight(1);

	for (var i = 1; i < history.points.length; i++) {
		//calculate position from previous location
		var fromX = b.map(history.points[i-1].lng, boundingArea.leftTop.lng,boundingArea.rightBottom.lng, 0, b.width);
		var fromY = b.map(history.points[i-1].lat, boundingArea.leftTop.lat,boundingArea.rightBottom.lat, 0, b.height);

		//calculate position from next location
		var toX = b.map(history.points[i].lng, boundingArea.leftTop.lng,boundingArea.rightBottom.lng, 0, b.width);
		var toY = b.map(history.points[i].lat, boundingArea.leftTop.lat,boundingArea.rightBottom.lat, 0, b.height);

		//draw line and previous location dot
		b.line(fromX, fromY, toX, toY);
		b.ellipse(fromX, fromY, 10, 10);

		//if last iteration of loop, also draw last dot
		if(i == (history.points.length-1)) {
			b.ellipse(toX, toY, 10, 10);
		}
	};
}

b.go();